close all
clear all
global u_t u_t1 jft
warning off

%T0=1; % to start in 1969m11
T0=75; % to start in 1976

addpath('C:\Dropbox\bpea\forecasts');

ur=csvread('v1ur.csv',T0,1);
ur0=ur;
uf_ARIMA=csvread('ur_arima.csv',T0,1);
uf_Ubar=csvread('ur_ustar.csv',T0,1);
uf_GB=csvread('ur_gb.csv',T0,1);
uf_SPF=csvread('ur_spf.csv',T0,1);
%NOTE: this is SSUR2 in real time
uf_SSUR2=csvread('ur_ssur2.csv',T0,1);
uf_VAR=csvread('ur_var.csv',T0,1);

eSS=uf_SSUR2-ur;

uStaff=uf_ARIMA;

%Get rid of the rows with zeros (ie no forecasts)
[rows,cols,vals] = find(uStaff(:,1)==0);
uStaff(rows,:)=[];
ur(rows,:)=[];
eSS(rows,:)=[];

eStaff=uStaff-ur;

disp('**********')
disp(horzcat('Relative MSE ofSSUR forecast:' ));
disp(horzcat('var SS model / var staff:' ));
disp(num2str(sum(eSS.^2,1)./sum(eStaff.^2,1)))

dssr=eStaff.^2-eSS.^2;
disp(horzcat([' ']));
for i=1:size(eSS,2)
    [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
    disp(horzcat(['Giacomini-White test at forecast horizon, p-values  ', num2str(i)], ':   ', num2str(pval) ));
end

% Giacomini-Rossi Fluctuation test
dssr=eStaff.^2-eSS.^2;

Ftest=[];cvtest=[];
for hz=1:3 % forecast horizon:
    DeltaLt=dssr(:,hz);
    [F,cvlow,cvup]=Fluctuation(DeltaLt,(1:length(eSS))',20,1,0.1); %20 for window of 5 years? where does forecast horizon enter? (it doesnt, I asked Barbara)
    % PLot the G-R Fluctuation test:
    
    F=[NaN(10,1);F;NaN(10,1)];
    cvlow=[NaN(10,1);cvlow;NaN(10,1)];
    cvup=[NaN(10,1);cvup;NaN(10,1)];
    
    Ftest(:,hz)=F; 
    cvtest=[cvtest cvlow cvup];
        
end

% Report the GR test at forecast horizons t+0 to t+2
FtestCN=Ftest;
for j=1:length(rows)
    i=rows(j);
    FtestCN=[FtestCN(1:i-1,:); zeros(1,3); FtestCN(i:end,:)];
end
FtestCN
